# Defines our constants
RACK_ENV = ENV['RACK_ENV'] ||= 'development' unless defined?(RACK_ENV)
PADRINO_ROOT = File.expand_path('../..', __FILE__) unless defined?(PADRINO_ROOT)

# Load our dependencies
# require 'bundler/setup'
# Bundler.require(:default, RACK_ENV)

gem 'rake'
gem 'activerecord', ">6.0"
if RACK_ENV == "production"
  gem 'mysql2' 
else
  gem 'sqlite3'
end
gem 'rspec'

# NOTE uninstall i18n 1.0
# gem "i18n", "~> 0.9" # conflicts with padrino-helpers-0.14.4 (i18n-1.x is the stable version)
gem "rolify"
gem "i18n"
gem 'padrino' #, '> 0.15.2'
gem 'padrino-cookies'
gem "bcrypt" # minw32 mgiht not work on windows
gem "builder"
gem "slack-notifier"
gem "nokogiri"
gem "coderay"
gem "childprocess"
if RUBY_PLATFORM =~ /mingw/
  gem "ffi"
end

gem "r18n-core"
gem "ci_reporter"
gem "httparty"
gem "archive-zip"
gem "rspec_junit_formatter"
gem "roo" # for upload user_stories

require 'active_record'
require 'padrino'
require 'padrino-cookies'
require 'httparty'
require 'archive/zip'

if RUBY_VERSION.to_i > 2
  # rexml/document is in a separate gem in Ruby 3
  gem 'rexml'
end

##
# ## Enable devel logging
#
# Padrino::Logger::Config[:development][:log_level]  = :devel
# Padrino::Logger::Config[:development][:log_static] = true

Padrino::Logger::Config[:demo] = { :log_level => :info, :stream => :to_file }
Padrino::Logger::Config[:local] = { :log_level => :debug, :stream => :to_file }
Padrino::Logger::Config[:integration] = { :log_level => :info, :stream => :to_file }

Padrino::Logger::Config[:production][:log_level] = :info
Padrino::Logger::Config[:production][:log_static] = true

# ## Configure Ruby to allow requiring features from your lib folder
#
# $LOAD_PATH.unshift Padrino.root('lib')
#
# ## Enable logging of source location
#
# Padrino::Logger::Config[:development][:source_location] = true
#
# ## Configure your I18n
#
# I18n.default_locale = :en
# I18n.enforce_available_locales = false
#
# ## Configure your HTML5 data helpers
#
# Padrino::Helpers::TagHelpers::DATA_ATTRIBUTES.push(:dialog)
# text_field :foo, :dialog => true
# Generates: <input type="text" data-dialog="true" name="foo" />
#
# ## Add helpers to mailer
#
# Mail::Message.class_eval do
#   include Padrino::Helpers::NumberHelpers
#   include Padrino::Helpers::TranslationHelpers
# end

##
# Require initializers before all other dependencies.
# Dependencies from 'config' folder are NOT re-required on reload.
#
Padrino.dependency_paths.unshift Padrino.root('config/initializers/*.rb')

##
# Add your before (RE)load hooks here
# These hooks are run before any dependencies are required.
#
Padrino.before_load do
end

##
# Add your after (RE)load hooks here
#
Padrino.after_load do
end

Padrino.load!
