class RevisionComparisonError < RuntimeError;
end

class Revision
  include Comparable

  DEBUG = false

  attr :contents

  def to_i
    @contents.join('').to_i
  end

  def to_s
    astring = @contents.collect { |j| j.to_s }.join(".")
  end







  def to_f
    (@contents[0].to_s + '.' + contents[1]..to_s).to_f
  end

  def [](i)
    return @contents[i]
  end

  def <=>(x)
    case x
      when String
        result = self <=> Revision.new(x)
      when Float
        f = self.to_f
        result = self.to_f <=> x
      when Revision
        len = [@contents.size, x.contents.size].max
        result = 0
        (0..(len-1)).each do |index|
          if result == 0
            result = ((@contents[index] || 0) <=> (x.contents[index] || 0))
          else
            break
          end
        end
        result
      else
        raise RevisionComparisonError.new("self is #{self}, other is #{x}")
    end
    result
  end


  def initialize(thing)
    if thing.class == Revision
      @contents = thing.contents.dup

    elsif thing.class == String
      result = thing.split(".").collect { |j| j.to_i }
      @contents = result
    elsif thing.class == Float
      @contents = thing.to_s.split(".").collect { |j| j.to_i }
    else
      raise "cannot initialise to #{thing}"
    end
  end

end