

module Buildwise
  class App
    module ProjectsHelper


      def find_project(project_id)
        if project_id && project_id =~ /^\d+$/
          if defined?(SERVER_DIGEST)
            @project = Project.where(:server_digest => SERVER_DIGEST, :id => project_id.to_i).first
          else
            @project = Project.find_by_id(project_id.to_i)
          end            
        else
          if defined?(SERVER_DIGEST)
            @project = Project.where(:server_digest => SERVER_DIGEST, :identifier => project_id).first
          else
            @project = Project.find_by_identifier(project_id)
          end
        end
      end


      def determine_reportable_time


        if params[:ends_at]
          @ends_at = Date.parse(params[:ends_at]).in_time_zone(Time.zone)                
        end
    
        if params[:starts_at]
          @starts_at = Date.parse(params[:starts_at]).in_time_zone(Time.zone)
        end
        
        @ends_at ||= Date.today.end_of_month
        @starts_at ||= Date.today.prev_month.prev_month.beginning_of_month    
        @query_ends_at =  @ends_at.to_time.tomorrow  - 1          

      end  
    
    end

    helpers ProjectsHelper
  end
end