require File.join(File.dirname(__FILE__), "../utils.rb")

module BuildWise
  module SCM
    class Base

      def initialize(path, config = {})
        raise "Path can't be nil" unless path

        @path, @config = path.strip, config
        @encoded_path = (@path.include?(' ') ? "\"#{@path}\"" : @path)
      end

      def url
        @path
      end

      def initial_checkout
        puts "TO BE OVERWRITTEN"
      end

      def last_successful_build_timestamp

        app_name = @config.application_name
        app_root = "#{BUILDWISE_HOME}/work/#{app_name}"
        status = BuildWise::Status.new("#{app_root}/status.log")
        commit_info = extract_commit_info(status.revision)
        begin
          @last_successful_build_timestamp = commit_info[status.last_successful_build_timestamp]
        rescue => e
          puts "!!!!failed to retrieve last_successful_build_timestamp, #{e}"
        end
      end


      def last_successful_build_revision
        app_name = @config.application_name
        app_root = "#{BUILDWISE_HOME}/work/#{app_name}"
        status = BuildWise::Status.new("#{app_root}/status.log")
        begin
          @last_successful_build_revision = status.revision
        rescue => e
          puts "!!!!failed to retrieve last_successful_build_revision, #{e}"
          1
        end
      end

    end
  end
end