class BuildWise::Publisher::Wemo < BuildWise::Publisher::Base

  attr_accessor :command
  attr_accessor :success_wemo
  attr_accessor :failure_wemo

  def initialize(opts = {})
    @name = "Wemo"
    @success_wemo = "http://#{opts[:success_ip]}:49153/"
    @failure_wemo = "http://#{opts[:failure_ip]}:49153/"
  end



  def switch_wemo_via_curb(ip_address, on_or_off)
    require 'curb'
    c = Curl::Easy.new(ip_address.to_s + 'upnp/control/basicevent1')
    signal = on_or_off ? "1" : "0"
    c.headers["Content-type"] = 'text/xml; charset="utf-8"'
    c.headers["SOAPACTION"] = "\"urn:Belkin:service:basicevent:1#SetBinaryState\""
    c.verbose = false
    begin
      c.http_post("<?xml version='1.0' encoding='utf-8'?><s:Envelope xmlns:s='http://schemas.xmlsoap.org/soap/envelope/' s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'><s:Body><u:SetBinaryState xmlns:u='urn:Belkin:service:basicevent:1'><BinaryState>#{signal}</BinaryState></u:SetBinaryState></s:Body></s:Envelope>")
      c.perform
    rescue => e
      puts "I can't access the wemo at this time #{e}, #{e.backtrace}"
    end

  end


  def switch_wemo(ip_address, on_or_off)
    require 'net/http'
    require 'uri'
    signal = on_or_off ? "1" : "0"
    uri = URI.parse(ip_address.to_s + 'upnp/control/basicevent1')
    http = Net::HTTP.new(uri.host, uri.port)
    header = {}
    header["Content-type"] = 'text/xml; charset="utf-8"'
    header["SOAPACTION"] = "\"urn:Belkin:service:basicevent:1#SetBinaryState\""
    req = Net::HTTP::Post.new(uri.request_uri, header)

    begin
      req.body = "<?xml version='1.0' encoding='utf-8'?><s:Envelope xmlns:s='http://schemas.xmlsoap.org/soap/envelope/' s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'><s:Body><u:SetBinaryState xmlns:u='urn:Belkin:service:basicevent:1'><BinaryState>#{signal}</BinaryState></u:SetBinaryState></s:Body></s:Envelope>"
      the_response = http.request(req)
      response_body = the_response.body


    rescue => e
      puts "I can't access the wemo at #{ip_address} now => #{e}, #{e.backtrace}"
    end
  end

  def turn_on(wemo_location)
    switch_wemo(wemo_location, true) if wemo_location
  end

  def turn_off(wemo_location)
    switch_wemo(wemo_location, false) if wemo_location
  end

  def publish(status, manager, build, options)









    the_build_state = status.current_state
    puts "#{Time.now} [DEBUG] Wemo status=> #{status.current_state} "
    puts "#{Time.now} [DEBUG] Wemo build=> #{build.id}"
    app_name = options[:application_name]
    puts "#{Time.now} [DEBUG] Wemo options=> #{app_name}"


    if the_build_state =~ /successful/i

      puts "#{Time.now} [INFO] Turn off red lamp"
      turn_off(@failure_wemo)
      puts "#{Time.now} [INFO] Turn on green lamp"
      turn_on(@success_wemo)

    elsif the_build_state =~ /revival/i

      turn_off(@failure_wemo)
      turn_on(@success_wemo)

    elsif the_build_state =~ /failed/i || the_build_state =~ /broken/i

      if status.previous_build_successful # just broke the build
        puts "#{Time.now} [INFO] [Wemo] broken build"
      else
        puts "#{Time.now} [INFO] [Wemo] still broken"
      end
      puts "[INFO] Failed: Turn on red lamp"
      turn_on(@failure_wemo)
      puts "[INFO] Failed: Turn off green lamp"
      turn_off(@success_wemo)
    else
      puts "#{Time.now} [INFO] [Wemo] unknown build status => |#{the_build_state}|"
    end

  end

end