module BuildWise
  module SCM
    TYPES = {
        :svn => 'SVN',
        :git => 'Git'
    }

    def self.get(type)
      class_name = TYPES[type.to_sym]
      say "SCM #{type} not supported" unless class_name
      require File.join(File.dirname(__FILE__), "scm/#{type}")
      const_get(class_name)
    end


    def self.guess_type(path)
      if test(?d, path)
        case
          when test(?d, path+'/.svn')

            'svn'
          when test(?d, path+'/.git')
            'git'
        end
      end
    end
  end

  module Publisher
    TYPES = {
        :mail => 'Mail',
        :twitter => 'Twitter',
        :storywise => "StoryWise",
        :wemo => 'Wemo',
        :slack => 'Slack'
    }

    def self.get(type, config)
      class_name = TYPES[type.to_sym]
      if not class_name
        class_name = config[:class_name]
        say "Publisher #{type} not supported" unless class_name
        require config[:require]
      else
        require "buildwise/publisher/#{type}"
      end
      const_get(class_name)
    end
  end

  module Builder
    TYPES = {
        :rake => 'Rake',
        :shell => "Shell",
        :command => "Shell",

        :ant => 'Ant',
        :ruby => 'Ruby',

    }

    def self.get(type)
      if type.nil? || type.empty?
        type = "shell"
      elsif type == "command"
        type = "shell"
      end
      class_name = TYPES[type.downcase.to_sym]
      say "Builder #{type} not supported" unless class_name
      require "buildwise/builder/#{type.downcase}"
      const_get(class_name)
    end
  end
end